% main program
% Gaussian_quadrature
wb=[2.22939364554E-013, 4.39934099226E-010, 1.08606937077E-007, ...
    7.8025564785E-006, 0.000228338636017, 0.00324377334224,...
    0.0248105208875,0.10901720602,0.286675505363,0.462243669601];
wb=[wb,wb]';
numb=[-5.38748089001, -4.60368244955,-3.94476404012,-3.34785456738, ...
    -2.78880605843, -2.25497400209, -1.73853771212, ...
    -1.2340762154,-0.737473728545,-0.245340708301];
numb=sqrt(2)*[numb,-numb]';

% Start Simulations 
rho1=1; r1=0; rho2=1; r2=0;
beta0=[1;-1]; nbeta=length(beta0); sigb20=1;
lambda10=0.3; lambda20=0.3;
tau=4;

n=100; nsim=5000;

npt=3; testpt=tau*(1:1:npt)'/(npt+1);
truepar=[beta0; beta0; lambda10*testpt; lambda20*testpt.^2/2; sigb20];
ncoef=2*nbeta;

parest=zeros(nsim, ncoef+1+2*npt);
sdest=zeros(nsim,  ncoef+1+2*npt);
cenrate1=0; cenrate2=0;
for simind=1:1:nsim
    rand('seed',123+simind);
    randn('seed',123+simind);
    [Y1, Delta1, Z1, Y2, Delta2, Z2]=simulation(beta0, sigb20, lambda10,...
        lambda20, n, rho1, r1, rho2, r2, tau);
    
    % use different beta's for Z1 and Z2
    Z1=[Z1, zeros(n, length(beta0))];
    Z2=[zeros(n,length(beta0)), Z2];
        
        
    indY1=(repmat(Y1,1,n)>=repmat(Y1',n,1));
    indY2=(repmat(Y2,1,n)>=repmat(Y2',n,1));
    n1=sum(Delta1); n2=sum(Delta2);
    
    oldcoef=[beta0;beta0]; oldsigb2=sigb20;
    oldlambda1=Delta1./(indY1*repmat(1,n,1));
    oldlambda2=Delta2./(indY2*repmat(1,n,1));

    epsilon=0.001;maxiter=100;error=1;iter=0;
    while (error>epsilon & iter< maxiter)
        [Exi1b, Exi2b, Ebb]=Estep(oldcoef, oldsigb2, oldlambda1, oldlambda2, ...
            Y1,Delta1,Z1,Y2,Delta2,Z2, indY1, indY2, n, ...
            rho1, r1, rho2, r2, numb,wb);
        [newcoef, newlambda1, newlambda2, newsigb2]=...
            Mstep(oldcoef, oldsigb2, Exi1b, Exi2b, Ebb,...
            Y1,Delta1,Z1,Y2,Delta2,Z2, indY1, indY2, n);
        error=sum(abs(newcoef-oldcoef)+abs(newsigb2-oldsigb2))+sum(abs(newlambda1-oldlambda1))...
            +sum(abs(newlambda2-oldlambda2));
        iter=iter+1;
        %[iter, error]
        %[beta0, newbeta]
        oldcoef=newcoef;
        oldsigb2=newsigb2;
        oldlambda1=newlambda1;
        oldlambda2=newlambda2;
    end
    cov=Covest(newcoef, newsigb2, newlambda1, newlambda2, ...
        Y1,Delta1,Z1,Y2,Delta2,Z2, indY1, indY2,n,...
        rho1, r1, rho2, r2, numb,wb);
    predmatrix=[diag(1+zeros(ncoef,1)), zeros(ncoef, n1+n2+1);
        zeros(npt, ncoef), repmat(testpt, 1,n1)>=repmat(Y1(Delta1==1)', npt, 1), zeros(npt, n2+1);
        zeros(npt, ncoef), zeros(npt, n1), repmat(testpt, 1, n2)>=repmat(Y2(Delta2==1)', npt, 1), zeros(npt,1);
        zeros(1, ncoef+n1+n2), 1];

    tempest=predmatrix*[newcoef; newlambda1(Delta1==1); newlambda2(Delta2==1); newsigb2];
    tempsd=sqrt(diag(predmatrix*cov*predmatrix'));
    parest(simind,:)=tempest';
    sdest(simind,:)=tempsd';
    cenrate1=(cenrate1*(simind-1)+n1/n)/simind;
    cenrate2=(cenrate2*(simind-1)+n2/n)/simind;
    if (simind>2)
        Sind=(1:1:simind)';
        [simind, cenrate1, cenrate2]
        indLambda=ncoef+(1:(2*npt));
        indsig=ncoef+2*npt+1;
        output=[truepar'; mean(parest(Sind,:))-truepar'; 
            sqrt(var(parest(Sind,:)));
            mean(sdest(Sind,:));
            mean(abs(parest(Sind,:)-repmat(truepar', simind,1))<1.96*sdest(Sind,:))];
        output(5, indLambda)=...
            mean(abs(log(parest(Sind, indLambda))-repmat(log(truepar(indLambda)'), simind,1))...
                 <1.96*sdest(Sind,indLambda)./parest(Sind, indLambda));
        % Satterthwaite approximation
        Z=power(parest(Sind,end),1/2)./sdest(Sind,end); nu=2*power(Z,2);
        output(5,end)=mean((nu.*parest(Sind,end)./chi2inv(0.975,nu)<= sigb20)...
                           .*(nu.*parest(Sind,end)./chi2inv(0.025,nu)>= sigb20));
        output
        save parest parest -ASCII;
        save sdest sdest -ASCII;
        save simind simind -ASCII;
        save cenrate1 cenrate1 -ASCII;
        save cenrate2 cenrate2 -ASCII;
        save output output -ASCII;
        if (simind==1000)
            output1000=output;
            save output1000 output1000 -ASCII;
        end
        if (simind==2000)
            output2000=output;
            save output2000 output2000 -ASCII;
        end
        if (simind==5000)
            ooutput5000=output;
            save output5000 output5000 -ASCII;
        end
    end
end

