% Data Structure: Y1, D1, Z1, Y2, D2, Z2
% Mstep

function [newcoef, newlambda1, newlambda2, newsigb2]=Mstep(oldcoef, oldsigb2, Exi1b, Exi2b, Ebb,... 
                                              Y1,Delta1,Z1,Y2,Delta2,Z2, indY1, indY2, n)

                                          
d=length(oldcoef);
EbetaZ1=exp(Z1*oldcoef);
EbetaZ2=exp(Z2*oldcoef);

score1=zeros(d,n);
dscore1=zeros(d,d);
for i=1:1:n
    temp=(indY1(:,i).*EbetaZ1.*Exi1b);
    tempnom=Z1'*temp;
    tempdenom=sum(temp);
    tempnom2=Z1'*(repmat(temp,1,d).*Z1);
    score1(:,i)=Delta1(i)*(Z1(i,:)'-tempnom/tempdenom);
    dscore1=dscore1-Delta1(i)*(tempnom2/tempdenom-tempnom*tempnom'/tempdenom^2);
end

score2=zeros(d,n);
dscore2=zeros(d,d);
for i=1:1:n
    temp=(indY2(:,i).*EbetaZ2.*Exi2b);
    tempnom=Z2'*temp;
    tempdenom=sum(temp);
    tempnom2=Z2'*(repmat(temp,1,d).*Z2);
    score2(:,i)=Delta2(i)*(Z2(i,:)'-tempnom/tempdenom);
    dscore2=dscore2-Delta2(i)*(tempnom2/tempdenom-tempnom*tempnom'/tempdenom^2);
end
    
newcoef=oldcoef-inv(dscore1+dscore2)*((score1+score2)*repmat(1,n,1));
EnewbetaZ1=exp(Z1*newcoef);
EnewbetaZ2=exp(Z2*newcoef);
newlambda1=Delta1./(indY1'*(EnewbetaZ1.*Exi1b));
newlambda2=Delta2./(indY2'*(EnewbetaZ2.*Exi2b));

newsigb2=mean(Ebb);