% Estep
% rho=0, (r1,r2) corresponds to gamma frailty (r1, r2):
% x^{r1-1}exp\{-x/r2\}
% rho>0 corresponds to 
function [Exi1b, Exi2b, Ebb]=Estep(coef, sigb2, lambda1, lambda2, ...
                                   Y1,Delta1,Z1,Y2,Delta2,Z2, indY1, indY2,n,...
                                   rho1, r1, rho2, r2, numb,wb)
nb=length(numb); BB=sqrt(sigb2)*numb;
Lambda1=indY1*lambda1;
Lambda2=indY2*lambda2;

LambdabetaZ1=(Lambda1.*exp(Z1*coef))*exp(BB');
LambdabetaZ2=(Lambda2.*exp(Z2*coef))*exp(BB');

[G1, dG1, ddG1, d3G1]=Gtransform(LambdabetaZ1, rho1, r1);
[G2, dG2, ddG2, d3G2]=Gtransform(LambdabetaZ2, rho2, r2);

temp1=-repmat(Delta1, 1, nb).*ddG1./dG1+dG1;
temp1=temp1.*exp(repmat(BB',n,1));

temp2=-repmat(Delta2, 1, nb).*ddG2./dG2+dG2;
temp2=temp2.*exp(repmat(BB',n,1));

weight=exp((Delta1+Delta2)*(BB)'+repmat(Delta1, 1, nb).*log(dG1)...
           +repmat(Delta2, 1, nb).*log(dG2)-G1-G2).*repmat(wb',n,1);
weight=weight./repmat(weight*repmat(1,nb,1),1,nb);

Exi1b=(temp1.*weight)*repmat(1,nb,1);
Exi2b=(temp2.*weight)*repmat(1,nb,1);
Ebb=weight*(BB.^2);

     