% covariance estimation using the Louis-formula
% rho=0, (r1,r2) corresponds to gamma frailty (r1, r2):
% x^{r1-1}exp\{-x/r2\}
% rho>0 corresponds to
function cov=Covest(coef, sigb2, lambda1, lambda2, ...
               Y1,Delta1,Z1,Y2,Delta2,Z2, indY1, indY2,n,...
                rho1, r1, rho2, r2, numb,wb)

nb=length(numb); ncoef=length(coef); BB=sqrt(sigb2)*numb;

templambda1=lambda1;
templambda1(Delta1==0)=1;
templambda2=lambda2;
templambda2(Delta2==0)=1;

Lambda1=indY1*lambda1;
Lambda2=indY2*lambda2;
EZ1b=exp(Z1*coef)*exp(BB');
EZ2b=exp(Z2*coef)*exp(BB');

LambdabetaZ1=repmat(Lambda1,1,nb).*EZ1b;
LambdabetaZ2=repmat(Lambda2,1,nb).*EZ2b;

[G1, dG1, ddG1, d3G1]=Gtransform(LambdabetaZ1, rho1, r1);
[G2, dG2, ddG2, d3G2]=Gtransform(LambdabetaZ2, rho2, r2);
weight=exp((Delta1+Delta2)*(BB)'+repmat(Delta1, 1, nb).*log(dG1)...
    +repmat(Delta2, 1, nb).*log(dG2)-G1-G2).*repmat(wb',n,1);
weight=weight./repmat(weight*repmat(1,nb,1),1,nb);

ddL=zeros(ncoef+2*n+1, ncoef+2*n+1); dLdL=ddL; EdLdL=ddL;
s1=(repmat(Delta1,1,nb).*ddG1./dG1-dG1).*EZ1b;
Es1=(s1.*weight)*repmat(1,nb,1);
s2=(repmat(Delta2,1,nb).*ddG2./dG2-dG2).*EZ2b;
Es2=(s2.*weight)*repmat(1,nb,1);
t1=(repmat(Delta1,1,nb).*(d3G1./dG1-ddG1.^2./dG1.^2)-ddG1).*power(EZ1b,2);
Et1=(t1.*weight)*repmat(1,nb,1);
t2=(repmat(Delta2,1,nb).*(d3G2./dG2-ddG2.^2./dG2.^2)-ddG2).*power(EZ2b,2);
Et2=(t2.*weight)*repmat(1,nb,1);

Icoef=(1:1:ncoef)'; I1=ncoef+(1:1:n)'; I2=ncoef+n+(1:1:n)'; Isigb2=ncoef+2*n+1;
temp=zeros(n, ncoef+2*n+1);
for m=1:1:nb
    dLi=zeros(n, ncoef+2*n+1);
    dLi(:,Icoef)=repmat(Delta1+Lambda1.*s1(:,m),1, ncoef).*Z1...
                 +repmat(Delta2+Lambda2.*s2(:,m),1,ncoef).*Z2;
    dLi(:,I1)=indY1.*repmat(s1(:,m),1,n);
    dLi(:,I1)=dLi(:,I1)+diag(Delta1./templambda1);
    dLi(:,I2)=indY2.*repmat(s2(:,m),1,n);
    dLi(:,I2)=dLi(:,I2)+diag(Delta2./templambda2);
    dLi(:,Isigb2)=-1/(2*sigb2)+(BB(m))^2/(2*sigb2^2);
    dLdL=dLdL+dLi'*(repmat(weight(:,m), 1, ncoef+2*n+1).*dLi);
    temp=temp+dLi.*repmat(weight(:,m),1,ncoef+2*n+1);
end
EdLdL=temp'*temp;

ddL(Icoef, Icoef)=Z1'*(repmat(Et1.*Lambda1.^2+Es1.*Lambda1,1,ncoef).*Z1)...
                  +Z2'*(repmat(Et2.*Lambda2.^2+Es2.*Lambda2,1,ncoef).*Z2);
ddL(Icoef, I1)=Z1'*(repmat(Et1.*Lambda1,1,n).*indY1)+Z1'*(repmat(Es1,1,n).*indY1);
ddL(Icoef, I2)=Z2'*(repmat(Et2.*Lambda2,1,n).*indY2)+Z2'*(repmat(Es2,1,n).*indY2);
ddL(I1,I1)=indY1'*(repmat(Et1,1,n).*indY1);
ddL(I2,I2)=indY2'*(repmat(Et2,1,n).*indY2);
ddL(Isigb2,Isigb2)=n/(2*sigb2^2)-1/(sigb2^3)*sum(weight*power(BB,2));
ddL(:, Icoef)=ddL(Icoef,:)';
ddL=ddL-diag([zeros(ncoef,1); Delta1./templambda1.^2; Delta2./templambda2.^2;0]);
information=-ddL-dLdL+EdLdL;
index=[1+zeros(ncoef,1); Delta1; Delta2; 1];
information=information(index==1, index==1);
cov=inv(information);



