function [effout, noconv]=EffSim2(K,n, beta0, beta1)

ID=repmat((1:K),n,1);
LID=reshape(ID,n*K,1);
strat=zeros(n*K,K);
for k=1:1:K
       strat(LID==k,k)=1;
end
strat=strat(:,1:(K-1));

simnum=10000;
MLE1=zeros(simnum,1); MLE2=zeros(simnum,1);
Meta1=zeros(simnum,1); Meta2=zeros(simnum,1);
MLEVAR1=MLE1; MLEVAR2=MLE2;
MetaVAR1=Meta1; MetaVAR2=Meta2;


total=0;
for simind=1:1:simnum
    
   rand('seed',simind);
   randn('seed',simind);

   X=zeros(n,K);
   Y=zeros(n,K);
   nom1=zeros(2,1); denom1=zeros(2,2);
   nom2=0; denom2=0;
   Kcenter=0;
   while (Kcenter<K)
       total=total+1;
       Xk=(rand(n,1)<0.5);
       Yk=(rand(n,1)>(1./(1+exp(beta0+beta1*Xk))));
       count=min([sum(Yk==0 & Xk==0), sum(Yk==1 & Xk==0), sum(Yk==0 & Xk==1), sum(Yk==1 & Xk==1)]);
       if (min(count)>0)
       Kcenter=Kcenter+1; X(:,Kcenter)=Xk; Y(:,Kcenter)=Yk;
       [b,dev,stats]=glmfit([Xk], [Yk, repmat(1,n,1)], 'binomial');
       %stats.se = vector of standard errors of the coefficient estimates b
       %stats.coeffcorr = correlation matrix for b 
       covb=stats.coeffcorr.*(stats.se*stats.se');
       nom1=nom1+inv(covb)*b; denom1=denom1+inv(covb);
       nom2=nom2+inv(covb(end,end))*b(end); denom2=denom2+inv(covb(end,end));
       end
       %Kcenter
   end
   est1=inv(denom1)*nom1; est2=inv(denom2)*nom2;
   sd1=inv(denom1); sd2=inv(denom2);
   Meta1(simind)=est1(end); Meta2(simind)=est2(end);
   MetaVAR1(simind)=sd1(end); MetaVAR2(simind)=sd2(end);
   
   LY=reshape(Y,n*K,1); LX=reshape(X,n*K,1);
   
   
   [coef,dev,stats]=glmfit([LX],[LY, repmat(1,n*K,1)],'binomial');
   MLE1(simind)=coef(end); MLEVAR1(simind)=stats.se(end)^2;
   [coef,dev,stats]=glmfit([strat,LX],[LY, repmat(1,n*K,1)],'binomial');
   MLE2(simind)=coef(end); MLEVAR2(simind)=stats.se(end)^2;
   
   
   if (simind>1)
       simind
       Cind=(1:simind)';
       out1=[var(MLE1(Cind))/var(Meta1(Cind)), var(MLE2(Cind))/var(Meta1(Cind)), ...
        var(MLE1(Cind))/var(Meta2(Cind)), var(MLE2(Cind))/var(Meta2(Cind))];
       out2=[mean(MLEVAR1(Cind)./MetaVAR1(Cind)), mean(MLEVAR2(Cind)./MetaVAR1(Cind)), ...
             mean(MLEVAR1(Cind)./MetaVAR2(Cind)), mean(MLEVAR2(Cind)./MetaVAR2(Cind))];
       out3=[var(MLE1(Cind)), var(MLE2(Cind)), var(Meta1(Cind)),var(Meta2(Cind))];
       out4=[mean(MLEVAR1(Cind)), mean(MLEVAR2(Cind)), mean(MetaVAR1(Cind)), mean(MetaVAR2(Cind))];
       out5=[sqrt(var(MLEVAR1(Cind)./MetaVAR1(Cind))), sqrt(var(MLEVAR2(Cind)./MetaVAR1(Cind))), ...
sqrt(var(MLEVAR1(Cind)./MetaVAR2(Cind))), sqrt(var(MLEVAR2(Cind)./MetaVAR2(Cind)))];
   end
    
end

       
effout=[out1; out2; out3; out4; out5];
noconv=(total-K*n*simnum)/total;
   
