EffSim2 <- function(K,n,beta0,beta1){ 

strat=matrix(0,n*K,K);
for (k in 1:K){
        strat[(k-1)*n+(1:n),k]=1;
}
strat=strat[,1:(K-1)];

simnum=1000;
MLE1=matrix(0,simnum,1); 
MLE2=matrix(0,simnum,1);
Meta1=matrix(0,simnum,1);
Meta2=matrix(0,simnum,1);
MLEVAR1=MLE1;
MLEVAR2=MLE2;
MetaVAR1=Meta1;
MetaVAR2=Meta2;

total=0;
for (simind in 1:simnum){
    
   
   Y=matrix(0,n,K); X=matrix(0,n,K);
   nom1=matrix(0,2,1); denom1=matrix(0,2,2);
   nom2=0; denom2=0;
   Kcenter=0;
   while (Kcenter<K){
       total=total+1;
       Xk=(runif(n)<0.5);
       Yk=(runif(n)>(1/(1+exp(beta0+beta1*Xk))));
       count=min(c(sum(Yk==0 & Xk==0), sum(Yk==1 & Xk==0), sum(Yk==0 & Xk==1), sum(Yk==1 & Xk==1)));
       if (min(count)>0){
       Kcenter=Kcenter+1; 
       Y[,Kcenter]=Yk;
       X[,Kcenter]=Xk;
       g=glm(Yk~Xk, family="binomial");
       b=g$coef;
       covb=summary(g)$cov.unscaled;
       nom1=nom1+solve(covb)%*%b; 
       denom1=denom1+solve(covb);
       nom2=nom2+solve(covb[2,2])*b[2]; 
       denom2=denom2+solve(covb[2,2]);
       }
   }
   est1=solve(denom1)%*%nom1; 
   est2=solve(denom2)%*%nom2;
   sd1=solve(denom1); 
   sd2=solve(denom2);
   Meta1[simind]=est1[2]; 
   Meta2[simind]=est2;
   MetaVAR1[simind]=sd1[2]; 
   MetaVAR2[simind]=sd2;
   
   LX=matrix(0,n*K,1);
   for (k in 1:K){
      LX[(k-1)*n+(1:n)]=X[,k];
   }
   LY=matrix(0,n*K,1);
   for (k in 1:K){
      LY[(k-1)*n+(1:n)]=Y[,k];
   }
   g=glm(LY~LX, family="binomial");
   MLE1[simind]=g$coef[2];
   MLEVAR1[simind]=summary(g)$cov.unscaled[2,2];
   
   g=glm(LY~strat+LX, family="binomial");
   MLE2[simind]=g$coef[K];
   MLEVAR2[simind]=summary(g)$cov.unscaled[K,K];
   
   if (simind>1){
       print(simind);
       Cind=(1:1:simind);
       out1=c(var(MLE1[Cind])/var(Meta1[Cind]), var(MLE2[Cind])/var(Meta1[Cind]),
        var(MLE1[Cind])/var(Meta2[Cind]), var(MLE2[Cind])/var(Meta2[Cind]));
       out2=c(mean(MLEVAR1[Cind]/MetaVAR1[Cind]), mean(MLEVAR2[Cind]/MetaVAR1[Cind]),
             mean(MLEVAR1[Cind]/MetaVAR2[Cind]), mean(MLEVAR2[Cind]/MetaVAR2[Cind]));
       out3=c(var(MLE1[Cind]), var(MLE2[Cind]), var(Meta1[Cind]),var(Meta2[Cind]));
       out4=c(mean(MLEVAR1[Cind]), mean(MLEVAR2[Cind]), mean(MetaVAR1[Cind]), mean(MetaVAR2[Cind]));
       out5=c(sqrt(var(MLEVAR1[Cind]/MetaVAR1[Cind])), sqrt(var(MLEVAR2[Cind]/MetaVAR1[Cind])), 
              sqrt(var(MLEVAR1[Cind]/MetaVAR2[Cind])), sqrt(var(MLEVAR2[Cind]/MetaVAR2[Cind])));
   }
    
}

       
effout=rbind(out1,out2,out3,out4,out5);
return(effout);
}
   
